import type { JobMetaPayload } from "@/app/components/JobMetaTags";
import { TypeFieldAnswer } from "@/lib/enums/TypeFieldAnswer";

export interface JobQuestion {
  id: number;
  // API قد يرجع إما title أو name / question
  title?: string | null;
  name?: string | null;
  question?: string | null;
  introduction?: string | null;
  // نوع الإجابة من الـ API
  type?: TypeFieldAnswer | string;
  answer_type?: TypeFieldAnswer | string | null;
  // خيارات الإجابة القادمة من الـ API
  job_appliction_fild_answer?: Array<{
    id: number;
    fild: string;
    answer_type?: TypeFieldAnswer | string | null;
  }>;
  required?: boolean;
  options?: Array<{ id: number; name: string }>;
}

export interface JobDetail extends JobMetaPayload {
  id: number;
  company: {
    id: number;
    name: string;
    logo?: string | null;
    subdomain?: string;
    website?: string | null;
    description?: string | null;
  };
  job_appliction_question?: JobQuestion[];
  workplace?: string;
  hours_number?: number | null;
  salary?: string | null;
  min_salary?: number | null;
  max_salary?: number | null;
  currency?: string | null;
  rate_salary?: string | null;
  salry_pay_by?: "range" | "fixed";
  job_type_job?: Array<{ id: number; job_type: { name: string } }>;
  benefits_job?: Array<{ id: number; name: string; description?: string }>;
  skill_job?: Array<{ id: number; name: string }>;
  job_contact_person?: Array<{
    user: {
      first_name: string;
      last_name: string;
      email: string;
      position?: string;
      photo?: string;
    };
  }>;
  tasks?: string;
  requirements?: string;
  invitation?: string;
  cv_is_required?: string;
  caver_latter_is_required?: string;
}
